<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Employe extends Model 
{

    protected $table = 'employes';
    public $timestamps = true;
    protected $fillable = array('hourly_rate', 'account_number', 'social_security_number', 'description', 'user_id');
    protected $visible = array('hourly_rate', 'account_number', 'social_security_number', 'description', 'user_id');

    public function users()
    {
        return $this->hasOne('App\Models\User');
    }

    public function events()
    {
        return $this->belongsToMany('App\Models\Event');
    }

    public function eventEmployes()
    {
        return $this->belongsTo('App\Models\EventEmploye');
    }

    public function payslips()
    {
        return $this->hasMany('App\Models\Payslip');
    }

}